IF EXISTS (SELECT *
           FROM   sys.objects
           WHERE  object_id = Object_id(N'[dbo].[P_EST_PROD_CPL_FACE_AGENDA]')
                  AND type IN ( N'P', N'PC' ))
DROP PROCEDURE [dbo].[P_EST_PROD_CPL_FACE_AGENDA];

GO


CREATE PROCEDURE [dbo].[P_EST_PROD_CPL_FACE_AGENDA](@CD_EMP INT=1)
AS
BEGIN

	UPDATE MDF
	SET
		QTDE_FINANCIADO=(CASE
						   WHEN AGD.TP_FACE_FIN=1
						   THEN ISNULL(AGD_PROD.QTDE_FACEAMENTO,0)
						   ELSE MDF.QTDE_FINANCIADO
						 END)
	   ,QTDE_FACEAMENTO=(CASE
						   WHEN AGD.TP_FACE_FIN=0
						   THEN ISNULL(AGD_PROD.QTDE_FACEAMENTO,0)
						   ELSE MDF.QTDE_FACEAMENTO
						 END)
	   ,VALID_QTDE_FACEAMENTO=(CASE
								 WHEN AGD.TP_FACE_FIN=0
								 THEN AGD_PROD.VALID_QTDE_FACEAMENTO
								 ELSE MDF.VALID_QTDE_FACEAMENTO
							   END)
	   ,PERC_ESEG_FACEAMENTO=(CASE
								WHEN AGD.TP_FACE_FIN=2
								THEN AGD_PROD.PERC_ESEG_FACEAMENTO
								ELSE MDF.PERC_ESEG_FACEAMENTO
							  END)
	   ,FLAG_FACE_COMPLEMENTAR=(CASE
								  WHEN AGD.TP_FACE_FIN=0
								  THEN ISNULL(AGD_PROD.FLAG_FACE_COMPLEMENTAR,0)
								  ELSE MDF.FLAG_FACE_COMPLEMENTAR
								END)
	   ,QTDE_LIMITADOR=(CASE
						  WHEN AGD.TP_FACE_FIN=3
						  THEN ISNULL(AGD_PROD.QTDE_FACEAMENTO,0)
						  ELSE MDF.QTDE_LIMITADOR
						END)
	   ,VALID_QTDE_LIMITADOR=(CASE
								WHEN AGD.TP_FACE_FIN=3
								THEN CASE
									   WHEN ISNULL(AGD_PROD.QTDE_FACEAMENTO,0)>0
									   THEN AGD_PROD.VALID_QTDE_FACEAMENTO
									   ELSE NULL
									 END
								ELSE MDF.VALID_QTDE_LIMITADOR
							  END)
		,DT_ULT_ALT = getdate()
		,CD_USU		= agd.CD_USU
	FROM 
		EST_PROD_CPL_FACE_AGENDA AGD
		INNER JOIN EST_PROD_CPL_FACE_AGENDA_EST_PROD AGD_PROD ON AGD.CD_EMP=AGD_PROD.CD_EMP
															 AND AGD.CD_AGD=AGD_PROD.CD_AGD
		INNER JOIN EST_PROD_CPL_MEDIAF MDF ON AGD_PROD.CD_EMP=MDF.CD_EMP
										  AND AGD_PROD.CD_FILIAL=MDF.CD_FILIAL
										  AND AGD_PROD.CD_PROD=MDF.CD_PROD
	WHERE
		 AGD.CD_EMP=@CD_EMP
		 AND AGD.STS_AGD=0
		 AND AGD.DT_AGD<=CONVERT(VARCHAR(10),GETDATE(),101);


	UPDATE MDF
	SET
		QTDE_FINANCIADO=(CASE
						   WHEN AGD.TP_FACE_FIN=1
						   THEN ISNULL(AGD_PROD.QTDE_FACEAMENTO,0)
						   ELSE MDF.QTDE_FINANCIADO
						 END)
	   ,QTDE_FACEAMENTO=(CASE
						   WHEN AGD.TP_FACE_FIN=0
						   THEN ISNULL(AGD_PROD.QTDE_FACEAMENTO,0)
						   ELSE MDF.QTDE_FACEAMENTO
						 END)
	   ,QTDE_LIMITADOR=(CASE
						  WHEN AGD.TP_FACE_FIN=3
						  THEN ISNULL(AGD_PROD.QTDE_FACEAMENTO,0)
						  ELSE MDF.QTDE_LIMITADOR
						END)
		,DT_ULT_ATU = getdate()
		,CD_USU		= agd.CD_USU
	FROM 
		EST_PROD_CPL_FACE_AGENDA AGD
		INNER JOIN EST_PROD_CPL_FACE_AGENDA_EST_PROD AGD_PROD ON AGD.CD_EMP=AGD_PROD.CD_EMP
																 AND AGD.CD_AGD=AGD_PROD.CD_AGD
		INNER JOIN EST_PROD_CPL MDF ON AGD_PROD.CD_EMP=MDF.CD_EMP
									   AND AGD_PROD.CD_FILIAL=MDF.CD_FILIAL
									   AND AGD_PROD.CD_PROD=MDF.CD_PROD
	WHERE
		 AGD.CD_EMP=@CD_EMP
		 AND AGD.STS_AGD=0
		 AND AGD.DT_AGD<=CONVERT(VARCHAR(10),GETDATE(),101);


	UPDATE AGD
	SET
		STS_AGD=1
	   ,DT_APLICACAO=GETDATE()
	FROM EST_PROD_CPL_FACE_AGENDA AGD
	WHERE
		 AGD.CD_EMP=@CD_EMP
		 AND AGD.STS_AGD=0
		 AND AGD.DT_AGD<=CONVERT(VARCHAR(10),GETDATE(),101);
END;
GO